import delimited "C:\Users\nsarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data November 2016\price_lt.csv", clear

gen newdate = date(date, "MDY")
gen quarter = quarter(newdate)
gen month = month(newdate)
gen year = year(newdate)
gen day = day(newdate)

tostring year, gen(year_string)
tostring quarter, gen(quarter_string)
gen year_quarter_string = year_string + quarter_string

gen cusip_short = substr(cusip, 1, 8)
drop cusip
rename cusip_short cusip 

gen mve = prc*shrout
gen mve_units = mve*1000
drop mve
rename mve_units mve

by cusip, sort: gen output_indicator = _n 
br cusip if output_indicator == 1 

save "C:\Users\nsarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data November 2016\price_lt.dta", replace


import delimited "C:\Users\nsarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data November 2016\assets_lt.csv", clear


gen newdate = date(datadate, "MDY")
gen quarter = quarter(newdate)
gen month = month(newdate)
gen year = year(newdate)
gen day = day(newdate)

gen cusip_short = substr(cusip, 1, 8)
drop cusip
rename cusip_short cusip 

tostring year, gen(year_string)
tostring quarter, gen(quarter_string)
gen year_quarter_string = year_string + quarter_string

by cusip, sort: gen output_indicator = _n 
br cusip if output_indicator == 1 

gen atq_units = atq*1000000
drop atq 
rename atq_units atq

capture drop output_indicator
by cusip year_quarter_string, sort: gen output_indicator = _n 
drop if output_indicator != 1

save "C:\Users\nsarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data November 2016\assets_lt.dta", replace

merge 1:m cusip year_quarter_string using "C:\Users\nsarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data November 2016\price_lt.dta"

save "C:\Users\nsarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data November 2016\assets_mve_merge_lt.dta", replace

clear
use "C:\Users\nsarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data November 2016\assets_mve_merge_lt.dta", replace
gen mve_assets_ratio = mve/atq

*** want to do for pre-crisis, crisis, post-crisis 
generate crisis = . 
replace crisis = 0 if year >= 2002 & year <= 2007 
replace crisis = 1 if year >= 2010 & year < 2016

/*generate crisis = . 
replace crisis = 0 if year >= 1995 & year <= 2005 
replace crisis = 1 if year == 2015 */


capture drop test 
by cusip, sort: gen test = _n 
gen big6 = 0 
replace big6 = 1 if permno == 86868 | permno == 47896 | permno == 69032 | permno == 59408 | permno == 38703 | permno == 70519
br if big6 == 1 & test == 1

*** now display for all banks 
drop output_indicator 
drop if _merge != 3
by crisis cusip, sort: egen mean_mve_ratio_crisis = mean(mve_assets_ratio)
by crisis cusip, sort: gen output_indicator = _n 
br tic cusip conm mean_mve_ratio_crisis crisis big6 if big6 == 1 & output_indicator == 1 
br tic cusip conm mean_mve_ratio_crisis crisis big6 if big6 == 0 & output_indicator == 1 


**** now we want a lt table for MVE/assets 


*** now by quintile
*** only want this for the non-big 6, so drop big6 here
drop if big6 == 1 
by crisis cusip, sort: egen markcap_crisis = mean(mve)
egen quant_markcap = xtile(markcap_crisis), n(5) by(crisis) 
by crisis quant_markcap, sort: egen mve_ratio_crisis_quant = mean(mve_assets_ratio)

drop output_indicator 
drop if crisis == . 
drop if quant_markcap == . 
by crisis quant_markcap, sort: gen output_indicator = _n 
br crisis quant_markcap markcap_crisis mve_ratio_crisis_quant if output_indicator == 1

by year cusip, sort: egen markcap_ann = mean(markcap)
egen quant_markcap_ann = xtile(markcap_ann), n(5) by(year) 
by year quant_markcap_ann, sort: egen mve_ann_quant = mean(mve_assets_ratio)
capture drop output_indicator
by year quant_markcap, sort: gen output_indicator = _n 
br year quant_markcap_ann mve_ann_quant if output_indicator == 1 & year == 2015 


 
